export interface Product {
  id: string;
  name: string;
  description: string;
  shortDescription: string;
  price: number;
  originalPrice?: number;
  category: string;
  images: string[];
  colors?: string[];
  sizes?: string[];
  stock: number;
  rating?: number;
  reviewCount?: number;
  specifications?: Record<string, string>;
  isFeatured?: boolean;
  isNew?: boolean;
}

export interface CartItem {
  product: Product;
  quantity: number;
  selectedColor?: string;
  selectedSize?: string;
}

export interface User {
  id: string;
  email: string;
  name: string;
  phone: string;
}

export interface ShippingAddress {
  fullName: string;
  phone: string;
  county: string;
  city: string;
  address: string;
  postalCode?: string;
}

export interface Order {
  id: string;
  userId: string;
  items: CartItem[];
  shippingAddress: ShippingAddress;
  subtotal: number;
  vat: number;
  shipping: number;
  total: number;
  paymentMethod: string;
  status: 'pending' | 'processing' | 'shipped' | 'delivered' | 'cancelled';
  createdAt: string;
}
