import { CartItem, User, Order } from "@/types/product";

// Cart Storage
export const getCart = (): CartItem[] => {
  try {
    const cart = localStorage.getItem('cart');
    return cart ? JSON.parse(cart) : [];
  } catch {
    return [];
  }
};

export const saveCart = (cart: CartItem[]): void => {
  localStorage.setItem('cart', JSON.stringify(cart));
};

export const clearCart = (): void => {
  localStorage.removeItem('cart');
};

// User Session Storage
export const getCurrentUser = (): User | null => {
  try {
    const user = localStorage.getItem('currentUser');
    return user ? JSON.parse(user) : null;
  } catch {
    return null;
  }
};

export const saveCurrentUser = (user: User): void => {
  localStorage.setItem('currentUser', JSON.stringify(user));
};

export const logout = (): void => {
  localStorage.removeItem('currentUser');
};

// Users Database (mock)
export const getUsers = (): User[] => {
  try {
    const users = localStorage.getItem('users');
    return users ? JSON.parse(users) : [];
  } catch {
    return [];
  }
};

export const saveUser = (user: User): void => {
  const users = getUsers();
  const existingIndex = users.findIndex(u => u.email === user.email);
  
  if (existingIndex >= 0) {
    users[existingIndex] = user;
  } else {
    users.push(user);
  }
  
  localStorage.setItem('users', JSON.stringify(users));
};

// Orders Storage
export const getOrders = (): Order[] => {
  try {
    const orders = localStorage.getItem('orders');
    return orders ? JSON.parse(orders) : [];
  } catch {
    return [];
  }
};

export const saveOrder = (order: Order): void => {
  const orders = getOrders();
  orders.unshift(order); // Add to beginning
  localStorage.setItem('orders', JSON.stringify(orders));
};

export const getUserOrders = (userId: string): Order[] => {
  return getOrders().filter(order => order.userId === userId);
};

export const updateOrderStatus = (orderId: string, status: Order['status']): void => {
  const orders = getOrders();
  const orderIndex = orders.findIndex(o => o.id === orderId);
  
  if (orderIndex >= 0) {
    orders[orderIndex].status = status;
    localStorage.setItem('orders', JSON.stringify(orders));
  }
};
