import { Product } from "@/types/product";
import headphonesImg from "@/assets/headphones.jpg";
import smartwatchImg from "@/assets/smartwatch.jpg";
import tshirtImg from "@/assets/tshirt.jpg";
import handbagImg from "@/assets/handbag.jpg";
import mugsImg from "@/assets/mugs.jpg";
import serumImg from "@/assets/serum.jpg";
import gamingMouseImg from "@/assets/gaming-mouse.jpg";
import runningShoes from "@/assets/running-shoes.jpg";

export const mockProducts: Product[] = [
  {
    id: "1",
    name: "Premium Wireless Headphones",
    shortDescription: "High-quality noise-cancelling headphones with superior sound",
    description: "Experience crystal-clear audio with these premium wireless headphones featuring active noise cancellation, 30-hour battery life, and comfortable over-ear design perfect for all-day listening.",
    price: 8500,
    originalPrice: 12000,
    category: "Electronics",
    images: [headphonesImg, headphonesImg, headphonesImg],
    colors: ["Black", "Silver", "Blue"],
    stock: 45,
    rating: 4.8,
    reviewCount: 124,
    specifications: {
      "Battery Life": "30 hours",
      "Connectivity": "Bluetooth 5.0",
      "Noise Cancellation": "Active ANC",
      "Weight": "250g"
    },
    isFeatured: true,
    isNew: false
  },
  {
    id: "2",
    name: "Smart Fitness Watch",
    shortDescription: "Track your health and fitness goals with style",
    description: "Advanced fitness tracker with heart rate monitoring, GPS, sleep tracking, and waterproof design. Perfect companion for your active lifestyle.",
    price: 12500,
    originalPrice: 15000,
    category: "Electronics",
    images: [smartwatchImg, smartwatchImg],
    colors: ["Black", "Rose Gold", "Silver"],
    stock: 30,
    rating: 4.6,
    reviewCount: 89,
    specifications: {
      "Display": "1.4\" AMOLED",
      "Battery": "7 days",
      "Water Resistance": "5 ATM",
      "GPS": "Built-in"
    },
    isFeatured: true,
    isNew: true
  },
  {
    id: "3",
    name: "Classic Cotton T-Shirt",
    shortDescription: "Comfortable everyday wear in premium cotton",
    description: "Soft, breathable 100% cotton t-shirt perfect for casual wear. Available in multiple colors and sizes to fit your style.",
    price: 1200,
    category: "Clothing",
    images: [tshirtImg, tshirtImg],
    colors: ["White", "Black", "Navy", "Grey"],
    sizes: ["S", "M", "L", "XL", "XXL"],
    stock: 150,
    rating: 4.5,
    reviewCount: 234,
    specifications: {
      "Material": "100% Cotton",
      "Fit": "Regular",
      "Care": "Machine washable"
    },
    isFeatured: false,
    isNew: false
  },
  {
    id: "4",
    name: "Designer Leather Handbag",
    shortDescription: "Elegant leather bag for the modern woman",
    description: "Handcrafted genuine leather handbag with spacious interior, multiple compartments, and adjustable strap. Perfect for work or casual outings.",
    price: 6500,
    originalPrice: 8500,
    category: "Fashion",
    images: [handbagImg, handbagImg, handbagImg],
    colors: ["Brown", "Black", "Tan"],
    stock: 20,
    rating: 4.9,
    reviewCount: 67,
    specifications: {
      "Material": "Genuine Leather",
      "Dimensions": "30x25x12 cm",
      "Compartments": "3 main + 2 side pockets"
    },
    isFeatured: true,
    isNew: false
  },
  {
    id: "5",
    name: "Ceramic Coffee Mug Set",
    shortDescription: "Beautiful handcrafted ceramic mugs, set of 4",
    description: "Set of 4 artisan ceramic coffee mugs with unique designs. Microwave and dishwasher safe. Each mug holds 350ml.",
    price: 2800,
    category: "Home",
    images: [mugsImg, mugsImg],
    stock: 85,
    rating: 4.7,
    reviewCount: 156,
    specifications: {
      "Material": "Ceramic",
      "Capacity": "350ml each",
      "Set": "4 pieces",
      "Care": "Dishwasher safe"
    },
    isFeatured: false,
    isNew: true
  },
  {
    id: "6",
    name: "Organic Face Serum",
    shortDescription: "Natural anti-aging serum with vitamin C",
    description: "Premium organic face serum enriched with vitamin C, hyaluronic acid, and natural botanicals. Reduces fine lines and brightens skin tone.",
    price: 3500,
    category: "Beauty",
    images: [serumImg],
    stock: 60,
    rating: 4.8,
    reviewCount: 203,
    specifications: {
      "Volume": "30ml",
      "Key Ingredients": "Vitamin C, Hyaluronic Acid",
      "Skin Type": "All types",
      "Organic": "Yes"
    },
    isFeatured: true,
    isNew: true
  },
  {
    id: "7",
    name: "Wireless Gaming Mouse",
    shortDescription: "High-precision mouse for competitive gaming",
    description: "Ultra-responsive wireless gaming mouse with RGB lighting, programmable buttons, and 20,000 DPI sensor. Battery lasts up to 70 hours.",
    price: 5200,
    originalPrice: 6500,
    category: "Electronics",
    images: [gamingMouseImg, gamingMouseImg],
    colors: ["Black", "White"],
    stock: 40,
    rating: 4.7,
    reviewCount: 98,
    specifications: {
      "DPI": "20,000",
      "Connectivity": "2.4GHz Wireless",
      "Battery": "70 hours",
      "Buttons": "8 programmable"
    },
    isFeatured: false,
    isNew: false
  },
  {
    id: "8",
    name: "Running Shoes Pro",
    shortDescription: "Professional running shoes with maximum comfort",
    description: "Engineered for performance with responsive cushioning, breathable mesh upper, and durable rubber outsole. Perfect for daily runs and marathons.",
    price: 7500,
    category: "Clothing",
    images: [runningShoes, runningShoes],
    colors: ["Black/White", "Blue/Yellow", "Grey/Orange"],
    sizes: ["39", "40", "41", "42", "43", "44", "45"],
    stock: 55,
    rating: 4.6,
    reviewCount: 187,
    specifications: {
      "Upper": "Breathable Mesh",
      "Sole": "Rubber Outsole",
      "Technology": "Responsive Cushioning",
      "Weight": "280g (size 42)"
    },
    isFeatured: true,
    isNew: false
  }
];

export const categories = [
  { id: "all", name: "All Products", count: mockProducts.length },
  { id: "electronics", name: "Electronics", count: mockProducts.filter(p => p.category === "Electronics").length },
  { id: "clothing", name: "Clothing", count: mockProducts.filter(p => p.category === "Clothing").length },
  { id: "home", name: "Home", count: mockProducts.filter(p => p.category === "Home").length },
  { id: "beauty", name: "Beauty", count: mockProducts.filter(p => p.category === "Beauty").length },
  { id: "fashion", name: "Fashion", count: mockProducts.filter(p => p.category === "Fashion").length }
];

export const kenyaCounties = [
  "Baringo", "Bomet", "Bungoma", "Busia", "Elgeyo-Marakwet", "Embu", "Garissa", "Homa Bay",
  "Isiolo", "Kajiado", "Kakamega", "Kericho", "Kiambu", "Kilifi", "Kirinyaga", "Kisii",
  "Kisumu", "Kitui", "Kwale", "Laikipia", "Lamu", "Machakos", "Makueni", "Mandera",
  "Marsabit", "Meru", "Migori", "Mombasa", "Murang'a", "Nairobi", "Nakuru", "Nandi",
  "Narok", "Nyamira", "Nyandarua", "Nyeri", "Samburu", "Siaya", "Taita-Taveta", "Tana River",
  "Tharaka-Nithi", "Trans-Nzoia", "Turkana", "Uasin Gishu", "Vihiga", "Wajir", "West Pokot"
];
